#include <MKL05Z4.h>
#include "hardware.h"
#include "LCD.h"
#include "matrix.h"
#include "main.h"
#include <stdlib.h>
#define ON_THRESHOLD 0x3F
#define OFF_THRESHOLD 0xFC

uint8_t shiftReg1;																										// shift registers for debouncing
uint8_t shiftReg2;							
uint8_t shiftReg3;							
uint8_t shiftReg4;							
uint8_t shiftReg5;	
uint8_t butState;																											// button states for debouncing							
uint8_t butFlag;																											// variable for button pressed

	uint8_t x, y, i, j, fruitX, fruitY, currDir, changeDir, back = 0;		//1 = right, 2 = up, 3 = down, 4 = left
	uint8_t head = 0;   																								// starting head index or total length without head
	uint8_t run = 1;																										// boolean value for determining if game loop needs to be running
																																			// run = true currently
	int32_t score = 0;
	uint8_t fruitOnScreen = 1;  																				// fruit on screen = false currently
	uint8_t buttonPressed;
	uint8_t toggleFruit = 1; 																						//switch every loop to blink candy.
	uint8_t snake[63][2];
	//uint8_t bitMap[8];
	uint8_t playingField[8][8];
	uint8_t x = 8, prevX = 0; 																					//Start pos x
	uint8_t y = 8, prevY = 0; 																					//start pos y
	uint8_t collision = 0; 																							// Set to true if collision. collision = false currently
	uint8_t incLength = 0; 																							// boolean for determining if tail needs to be incremented, set to false currently
	//uint8_t bitMap[8];
	uint8_t bitMap[8];
	uint32_t counter = 0;
	uint32_t speed = 250;
	uint8_t number3[8] =  {0x00, 0x66, 0x99, 0x99, 0x99, 0x99, 0x99, 0x00};
	uint8_t number2[8] = {0x00, 0x41, 0xa1, 0x91, 0x89, 0x45, 0x23, 0x00};
	uint8_t number1[8] = {0x00, 0x01, 0x01, 0xff, 0xff, 0x61, 0x21, 0x00};
	uint8_t gameOverX[8] = {0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81};
/*
	number3[] =
	01111100
	00000010
	00000010
	01111100
	01111100
	00000010
	00000010
	01111100
	
	number2[] =
	00011100
	00100010
	01000100
	00001000
	00010000
	00100000
	01000000
	01111100
	
	number1[] =
	00011000
	00111000
	01111000
	00011000
	00011000
	00011000
	00011000
	01111110
	*/
	int p1 = 3, p2 = 0;        // random number generator variables
	long table[31];
	const long MaxLong = 0x7fffffff;
	
int main(void)
{
	SMC_setup();							// configure low-power modes	
	PORTS_setup();						// I/O ports setup	
	SPI0_setup();							// setup for I2C0 module
	TPM1_setup();
	LCD_setup();
	Matrix_setup();
	LPTMR0_setup();				
	RNG_7up(1);								// for random number generator
	
	// displays all LEDs on for about 1/4 second
	for (counter = 0; counter < 200; counter++)
	{
		for (i = 0; i < 8; i++)
		{
				bitMap[i] = 0xFF;
		}	
		Matrix_retrace();
		__WFI();
	}
	
	// displays number 3 for ~1 second
	for (counter = 0; counter < 800; counter++)
	{
		for (i = 0; i < 8; i++)
		{
			bitMap[i] = number3[i];
		}
		Matrix_retrace();
		__WFI();
	}
	
	// displays number 2 for ~1 second
	for (counter = 0; counter < 800; counter++)
	{
		for (i = 0; i < 8; i++)
		{
			bitMap[i] = number2[i];
		}
		Matrix_retrace();
		__WFI();
	}
	
	// displays number 1 for ~1 second
	for (counter = 0; counter < 800; counter++)
	{
		for (i = 0; i < 8; i++)
		{
			bitMap[i] = number1[i];
		}
		Matrix_retrace();
		__WFI();
	}
	
	// set up initial LCD display
	LCD_setCursor(0,0);
	LCD_writeString("Score:   (^.^)go");
	LCD_setCursor(1,0);
	LCD_writeString("  ");
	LCD_writeInt(score);
	LCD_writeString("      go(^.^)");
	
	// set all values of snake to 0
	for (i = 0; i < 63; i++)
	{
		snake[i][0] = 0;
		snake[i][1] = 0;
	}

	// sets snake into initial playingfield
	for (i = 0; i < 8; i++)
		{
			for (j = 0; j < 8; j++)
			{
				if (i + 1 == x && j + 1 == y)
					playingField[i][j] = 1;
			}
		}
	
	// reset counter
	counter = 0;
		
	// set head location into snake array
	snake[0][0] = x;
	snake[0][1] = y;
		
		
	while(run) // while run = true application runs, only changed by gameover currently
	{ 
		__WFI();
		
		checkMove();							// check user input
		
		if (counter == speed)  		// runs based on speed set by either default value or user given value
		{
			doMove();								// execute move 
			checkCollisionWall();  	// check if snake has collided with wall or the snake
			checkFruitCollision(); 	// check if fruit has been eaten
			printScore();						// print the score 
			
			counter = 0;						// reset counter 
		}
		
		
		while (fruitOnScreen == 1) createFruit(); 							//radnomize new candy position. Keep going until a valid position is set
  
		if(counter == (speed/2) || counter == 0) blinkFruit();	// blinkspeed = half of the speed variable
		
		// set values of playingField into the bitMap to display on the dot matrix
		for (i = 0; i < 8; i++)
		{
				bitMap[i] = (playingField[i][0] << 7) + (playingField[i][1] << 6) 
				+ (playingField[i][2] << 5) + (playingField[i][3] << 4)
				+ (playingField[i][4] << 3) + (playingField[i][5] << 2)
				+ (playingField[i][6] << 1) + (playingField[i][7]);
		}
		
		// if collision is true then run game over function
		if (collision) gameOver();
		
		// remove the last tail segment from the playingField array
		playingField[prevX - 1][prevY - 1] = 0;
		
		// update dot matrix
		Matrix_retrace();
		
		// update counter
		counter++;
	}
}	
/**
  * Game over.
  */
	void gameOver(void)
	{
		// gameOver code
		run = 0;			// run = false
		for (i = 0; i < 8; i++)
        {
            bitMap[i] = gameOverX[i];
        }
		
		//print gameover on LCD 
		LCD_setCursor(0,0);
		LCD_writeString("GameOver!<(x.x)>");
		LCD_setCursor(1,0);
		LCD_writeString("Score:");
		LCD_writeInt(score);
		if (score >= 0 && score < 100)
				LCD_writeString("   -.-   ");
		if (score >= 100 && score < 200)
				LCD_writeString(" d(~_O)");
		if (score >= 200)
				LCD_writeString(" d(^_^)");
	
		// display X until center button is pressed
		while(!(butFlag & 0x10))								// loop is only needed for debugging
		{			
			__WFI();							// wait for wake-up event
			Matrix_retrace();
		}

		// reset user input
		__WFI();
		// loop displaying number1[] until user presses center
		while (!(butFlag & 0x10))
		{
			__WFI();
			for (i = 0; i < 8; i++)
			{
				bitMap[i] = number1[i];
			}
			Matrix_retrace();
			speed = 250;
			if (butFlag & 0x04)
			{
				// loop displaying number2[] until user presses center or return back to number1[] if down is pushed
				while (!(butFlag & 0x10) && back != 1)
				{
						__WFI();
						for (i = 0; i < 8; i++)
						{
								bitMap[i] = number2[i];
						}
						Matrix_retrace();
						speed = 180;
						back = 0;												// reset back to zero to be able to go back to number3[]
						if (butFlag & 0x08) back = 1;		// used to return back to previous loop
						if (butFlag & 0x04)
						{
							// loop displaying number3[] until user presses center or return back to number2[] if down is pushed
								while (!(butFlag & 0x10) && back != 2)
								{
										__WFI();
										for (i = 0; i < 8; i++)
										{
												bitMap[i] = number3[i];
										}
										Matrix_retrace();
										speed = 100;
										if (butFlag & 0x08) back = 2;					// used to return back to previous loop
								}
						}
				}		
			}
			// reset back to zero
			back = 0;
		}
		
		// reset the game variables
		run = 1;
		changeDir = head = score = collision = buttonPressed = currDir = 0;
		x = y = 8;
		for (i = 0; i < 8; i++)
		{
			for (j = 0; j < 8; j++)
			{
				playingField[i][j] = 0;
			}
		}
	} 


 
/*Blink the fruit*/
void blinkFruit(void)
{
	 if (toggleFruit == 1)
	 {
		// turn on fruit led
		playingField [fruitX - 1][fruitY - 1] = 1;
		toggleFruit = 0;
		
	 }
	 else
	 {
		// turn off fruit led
		playingField [fruitX - 1][fruitY - 1] = 0;
		toggleFruit = 1;
	 }
}





  /*
  *  Turn on LEDs and turn off last LED in tail
  */
void led(void)
{
	
	uint8_t xTemp;
	uint8_t yTemp;
	
	
	// if no fruit collision
  if(!incLength)
	{
    //Turn off the last light at the tail
    playingField[snake[0][0] - 1][snake[0][1] - 1] = 0;
		playingField[snake[0][0] - 1][snake[0][1] - 1] = 0;
		
		// reorder the snake array so that every i is shifted down 1 in the snake array until i = head
		for(i = 0; i < head; i++)
		{
			snake[i][0] = snake[i+1][0];
			snake[i][1] = snake[i+1][1];
		}
 
  }
  else // if fruit collision
	{ 
    head++;
    incLength = 0;
  }
	
	// set values of x and y into snake at position of the head
  snake[head][0] = x;
  snake[head][1] = y;

  
  // sets values of snake into playing field
  for (i = 0; i <= head; i++)
  {
		if (snake[i][0] != 0 || snake[i][1] != 0)
		{
			xTemp = snake[i][0];
			yTemp = snake[i][1];
			playingField[xTemp - 1][yTemp - 1] = 1;
		}
  }
	
}




//Read input from buttons
void checkMove(void)
{
    if (butFlag & 0x01)			// if left button is pressed
		buttonPressed = 4;
	else if (butFlag & 0x02)		// if right button is pressed
		buttonPressed = 1;
	else if (butFlag & 0x04)		// if up button	is pressed
		buttonPressed = 2;
	else if (butFlag & 0x08)		// if down button is pressed
		buttonPressed = 3;
	
	//check for button pressed
	//1 = right, 2 = up, 3 = down, 4 = left
  if(currDir != 4 && buttonPressed == 1) changeDir  = 1; //Go right, if snake is not moving left
  if(currDir != 1 && buttonPressed == 4) changeDir  = 4; //Go left, if snake is not moving right
  if(currDir != 3 && buttonPressed == 2) changeDir  = 2; //Go up, if snake is not moving down
  if(currDir != 2 && buttonPressed == 3) changeDir  = 3; //Go down, if snake is not moving up}
}
  /*
  *  Move snake based on currDir
  */
void doMove(void)
{
  currDir = changeDir;
  if(currDir == 1) moveRight();
  if(currDir == 2) moveUp();
  if(currDir == 3) moveDown();
  if(currDir == 4) moveLeft();
  led();													// update head with new x and y coordinates
	
}
 
/*
 *Increment length
 */
void incrementLength(void)
{
  incLength = 1; 
}
 
void moveRight(void)
{
  x--;
}
void moveLeft(void)
{
  x++;
}
void moveUp(void)
{
  y--;
}
void moveDown(void)
{
  y++;
}

// rng function
long Rand() 
{ 
  int r; 
  table[p1] = table[p1] + table[p2]; // update the table element 
  r = (table[p1] >> 1) & MaxLong;    // drop the least significant bit  

  if (p1 == 30)                      // update the table indices
  {
    p1 = 0; 
    p2++; 
  } 
  else if (p2 == 30) 
  { 
    p1++; 
    p2 = 0; 
  } 
  else 
  { 
    p1++; 
    p2++; 
  } 

  return r; 
} 

// this auxilary function sets up the RNG table according to the seed
void RNG_7up (long seed)  
{ 
  int i; 
  table[0] = seed; 
  for (i=1; i<31; i++)         // here a simple linear RNG is used for the table
    table[i] = (table[i-1] * 1103515145) + 12345;  
  for (i=0; i<10; i++)         // cycle up the table 10 times for better results
    Rand(); 
} 
 

 
/*create candy*/
void createFruit(void)
{
	// get random numbers for x and y
	uint8_t xTemp = Rand() % 8 + 1;
	uint8_t yTemp = Rand() % 8 + 1;

	// check to see if random numbers match the locations of the snake
  for(i = 0; i <= head; i++)
	{
    if(xTemp == snake[i][0] && yTemp == snake[i][1])
	{
      fruitOnScreen = 1; 
      return;
    }
  }
	// since random numbers do not match a location in the snake, set variables to random numbers
  fruitX = xTemp;
  fruitY = yTemp;
  fruitOnScreen = 0;
  
  // turn on led for fruit
  playingField [fruitX - 1][fruitY - 1] = 1;
	
	
}
 
/*Check for collision with candy*/
void checkFruitCollision(void)
{
  if(snake[head][0] == fruitX && snake[head][1] == fruitY)
	{
    fruitOnScreen = 1; 
    incrementLength();
  }
}
 
 
/*Checks collision with snake and wall. */
void checkCollisionWall(void)
{
  uint8_t xP = snake[head][0];
  uint8_t yP = snake[head][1];
 
	// check for out of bounds
  if(xP < 1 || xP > 8 || yP < 1 || yP > 8)
	{
    collision = 1;
    return;
  }
  else		
	{
		// check for snake tail collision
    for(i = 0; i < head; i++)
		{
      if(snake[i][0] == xP && snake[i][1] == yP){
        collision = 1;
        return;
      }
    }
  }
}

/*
 * print score function
 */
void printScore(void)
{
	if (speed == 180)	score = head * 10;		// score calculated based on speed choosen
	if (speed == 100) score = head * 15;
	if (speed == 250) score = head * 5;
	
	// send score to LED
	LCD_setCursor(1,0);
	if (score < 10) LCD_writeString("  ");
	else if (score < 100) LCD_writeString(" ");
	LCD_writeInt(score);
	LCD_writeString("      go(^.^)");
	
}


void LPTimer_IRQHandler(void)				// LPTMR0 ISR
{
		SCB->SCR = 0;																											// cancel deep sleep mode
		LPTMR0->CSR |= LPTMR_CSR_TCF_MASK;																// clear interrupt flag
	
		// check for left button being pressed
		butFlag = 0;						// mark all buttons as not pressed
		shiftReg1 = (shiftReg1 >> 1) | ((PTB->PDIR & buttonLeft)); 				// update shift register
		if (butState & 0x1)																								// check state of buttonLeft	
		{
			if (shiftReg1 <= ON_THRESHOLD)																	// button is pressed
			{
				butState &= ~0x01;																						// mark button as pressed	
				butFlag |= 0x1;																								// set flag for buttonLeft
			}
		}
		else if (shiftReg1 >= OFF_THRESHOLD)															// button is released
			butState |= 0x1;																								// mark button as released	
	
		// check for right button being pressed
		shiftReg2 = (shiftReg2 >> 1) | ((PTB->PDIR & buttonRight) << 3); 	// update shift register
		if (butState & 0x2)																								// check state of buttonRight	
		{
			if (shiftReg2 <= ON_THRESHOLD)																	// button is pressed
			{
				butState &= 0xFD;																							// mark button as pressed	
				butFlag |= 0x2;																								// set flag for buttonRight
			}
		}
		else if (shiftReg2 >= OFF_THRESHOLD)															// button is released
			butState |= 0x2;																								// mark button as released
	
		// check for up button being pressed
		shiftReg3 = (shiftReg3 >> 1) | ((PTB->PDIR & buttonUp) << 1); 		// update shift register
		if (butState & 0x4)																								// check state of buttonUp	
		{
			if (shiftReg3 <= ON_THRESHOLD)																	// button is pressed
			{
				butState &= 0xFB;																							// mark button as pressed	
				butFlag |= 0x4;																								// set flag for buttonUp	
			}
		}
		else if (shiftReg3 >= OFF_THRESHOLD)															// button is released	 
			butState |= 0x4;																								// mark button as released
	
		// check for down button being pressed
		shiftReg4 = (shiftReg4 >> 1) | ((PTB->PDIR & buttonDown) << 4); 	// update shift register
		if (butState & 0x8)																								// check state of buttonDown	
		{
			if (shiftReg4 <= ON_THRESHOLD)																	// button is pressed
			{
				butState &= 0xF7;																							// mark button as pressed	
				butFlag |= 0x8;																								// set flag for buttonDown	
			}
		}
		else if (shiftReg4 >= OFF_THRESHOLD)															// button is released	 
			butState |= 0x8;																								// mark button as released
	
		// check for center button being pressed
		shiftReg5 = (shiftReg5 >> 1) | ((PTB->PDIR & buttonCenter) << 2); // update shift register
		if (butState & 0x10)																							// check state of buttonCenter	
		{
			if (shiftReg5 <= ON_THRESHOLD)																	// button is pressed
			{
				butState &= 0xEF;																							// mark button as pressed	
				butFlag |= 0x10;																							// set flag for buttonCenter	
			}
		}
		else if (shiftReg5 >= OFF_THRESHOLD)															// button is released	 
			butState |= 0x10;																								// mark button as released

}

void TPM1_IRQHandler(void)					// TPM1 is used for short delays
{											//   in interfacing with LCD
	TPM1->SC = TPM_SC_TOF_MASK;				// clear IF and stop timer
}
